package com.example.sefinsa_app.ui.avales.editar;

import static com.example.sefinsa_app.utilities.BluetoothUtils.context;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ClipData;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.provider.MediaStore;
import android.provider.Settings;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigation;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.AvalesWorker;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosDialogFragment;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.RealPathUtil;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class AvalesEditarFragment extends Fragment {
    // A nivel de clase
    private Aval avalActual;                 // el aval que llegó en el bundle
    private String pendingRutaId = "";
    private String pendingPoblacionId = "";
    private String pendingColocadoraId = "";


    private AvalesEditarViewModel mViewModel;

    private TextInputLayout tlAval, tlTelefonoAval, tlDireccionAval, tlOtrasReferenciasAval, tlGarantiasAval, tlRuta, tlPoblacion, tlColocadora;

    private AutoCompleteTextView  avalesAutoCompleteTextView,  rutasAutoCompleteTextView,
            poblacionesAutoCompleteTextView, colocadorasAutoCompleteTextView;

    private Uri image_uri,selectedImageUri,uri;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private final int CODIGO_PERMISOS_CAMARA = 1;

    private Button btnEditarAval, btnSubirFotos, btnUbicacion;

    private Bitmap bitmap;
    private ArrayList<Bitmap> bitmaps;

    private String aval_id = "";
    private String ruta_id = "";
    private String poblacion_id = "";
    private String colocadora_id = "";
    private final String cliente_id2 = "";
    private int previousLengthAval;
    private boolean backSpaceAval;
    private final boolean camaraGarantiasAvalAbierta = false;
    private final boolean camaraComprobantesAvalAbierta = false;

    List<MultipartBody.Part> archivosGeneral;
    private ArrayList<Aval> avales;
    private ArrayAdapter<Aval> avalesAdapter;
    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;

    private int banderaGarantiasAvales, banderaComprobantesAvales;

    String path;
    Bundle bundle;
    String lat = "";
    String lgt = "";
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;

    public static AvalesEditarFragment newInstance() {
        return new AvalesEditarFragment();
    }
    private void showAlert(String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage(message);

        // Personaliza el título para centrarlo
        TextView title = new TextView(context);
        title.setText("Alerta");
        title.setGravity(Gravity.CENTER);
        title.setTextSize(TypedValue.COMPLEX_UNIT_SP, 20);
        title.setTextColor(ContextCompat.getColor(context, android.R.color.black));
        title.setPadding(0, 20, 0, 20);

        builder.setCustomTitle(title);

        builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                // Acciones al hacer clic en Aceptar
            }
        });

        AlertDialog dialog = builder.create();
        dialog.show();
    }
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_avales_editar, container, false);
    }
    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        AvalesWorker.cancelWork(requireContext());
        Bundle bundle = this.getArguments();
        initElements(view);
        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        colocadoras = new ArrayList<Colocadora>();
        getRutas();
        if(poblaciones.size() == 0){
            getPoblaciones();
        }
        if(colocadoras.size() == 0){
            getColocadoras();
        }
        Bundle args = getArguments();
        String personJsonString = args.getString("aval");
        //Log.d("AvalesEditFragment", "Valor recibido en personJsonString: " + personJsonString);
        Aval aval = Utils.getGsonParser().fromJson(personJsonString, Aval.class);

        tlAval.getEditText().setText(aval.getNombre_completo());
        tlTelefonoAval.getEditText().setText(aval.getTelefono());
        tlDireccionAval.getEditText().setText(aval.getDireccion());
        tlOtrasReferenciasAval.getEditText().setText(aval.getOtras_referencias());
        tlGarantiasAval.getEditText().setText(aval.getGarantias());
        // Asignar la ruta, población y colocadora correctas usando el id
        setRutaAutoComplete(aval.getRuta_id());
        setPoblacionAutoComplete(aval.getPoblacion_id());
        setColocadoraAutoComplete(aval.getColocadora_id());

        /*
        if (rutasAutoCompleteTextView != null) {
            rutasAutoCompleteTextView.setText(aval.getNombre_ruta() != null ? aval.getNombre_ruta() : "");
        }

        if (poblacionesAutoCompleteTextView != null) {
            poblacionesAutoCompleteTextView.setText(aval.getNombre_poblacion() != null ? aval.getNombre_poblacion() : "");
        }

        if (colocadorasAutoCompleteTextView != null) {
            colocadorasAutoCompleteTextView.setText(aval.getNombre_colocadora() != null ? aval.getNombre_colocadora() : "");
        }
        */

        aval_id = aval.getId();

        avales = new ArrayList<Aval>();

        Log.d("DATA_ENVIADA", "Json de avales aval_id: " + aval_id);

        bundle = getArguments();
        if (bundle != null) {
            avales = (ArrayList<Aval>) bundle.getSerializable("avales");
        }

        if (avales == null) {
            avales = new ArrayList<Aval>();
        }

        if (avales.size() == 0) {
            //getAvales();
        }
        avalesAdapter = new ArrayAdapter<Aval>(getContext(), android.R.layout.simple_dropdown_item_1line, avales);
        // Corregir el error aquí
        avalesAutoCompleteTextView = view.findViewById(R.id.acNombreAval);

        if (avalesAutoCompleteTextView != null) {
            avalesAutoCompleteTextView.setThreshold(1);
            avalesAutoCompleteTextView.setAdapter(avalesAdapter);
        }

        avalesAutoCompleteTextView.setThreshold(1);
        avalesAutoCompleteTextView.setAdapter(avalesAdapter);

        avalesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                if (!tlAval.getEditText().getText().toString().isEmpty() || tlAval.getEditText().getText() != null) {
                    AvalController ac = new AvalController(getContext());
                    String avalId = ac.getAvalByNombre(tlAval.getEditText().getText().toString().toUpperCase());
                    if (!avalId.isEmpty() || avalId != null) {
                        ClienteController cc = new ClienteController(getContext());
                        String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(tlAval.getEditText().getText().toString().toUpperCase());
                        if (Objects.equals(prestaNombre, "1")) {
                            AlertDialog.Builder b = new AlertDialog.Builder(getContext());
                            b.setTitle("Aviso");
                            b.setMessage("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                            b.setPositiveButton("Aceptar", null);

                            tlAval.getEditText().setText("");

                            AlertDialog dialog = b.create();
                            dialog.show();
                        } else {
                            Aval aval = avalesAdapter.getItem(i);
                            aval_id = aval.getId();

                            tlTelefonoAval.getEditText().setText(aval.getTelefono());
                            tlDireccionAval.getEditText().setText(aval.getDireccion());
                            tlOtrasReferenciasAval.getEditText().setText(aval.getOtras_referencias());
                            tlGarantiasAval.getEditText().setText(aval.getGarantias());
                        }
                    } else {
                        Aval aval = avalesAdapter.getItem(i);
                        aval_id = aval.getId();

                        tlTelefonoAval.getEditText().setText(aval.getTelefono());
                        tlDireccionAval.getEditText().setText(aval.getDireccion());
                        tlOtrasReferenciasAval.getEditText().setText(aval.getOtras_referencias());
                        tlGarantiasAval.getEditText().setText(aval.getGarantias());
                    }
                } else {
                    Aval aval = avalesAdapter.getItem(i);
                    aval_id = aval.getId();

                    tlTelefonoAval.getEditText().setText(aval.getTelefono());
                    tlDireccionAval.getEditText().setText(aval.getDireccion());
                    tlOtrasReferenciasAval.getEditText().setText(aval.getOtras_referencias());
                    tlGarantiasAval.getEditText().setText(aval.getGarantias());
                }
            }
        });

        avalesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int i, int i1, int i2) {
                previousLengthAval = s.length();
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpaceAval = previousLengthAval > s.length();
                if (backSpaceAval && !aval_id.equals("")) {

                    avalesAutoCompleteTextView.setText("");
                    tlTelefonoAval.getEditText().setText("");
                    tlDireccionAval.getEditText().setText("");
                    tlOtrasReferenciasAval.getEditText().setText("");
                    tlGarantiasAval.getEditText().setText("");

                    aval_id = "";
                }
            }
        });

        btnSubirFotos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                getCurrentLocation();
                AvalesFotosDialogFragment dialogFragment = new AvalesFotosDialogFragment();
                /*
                Bundle args = new Bundle();

                args.putString("aval", ""); // Pasar un JSON vacío o nulo
                args.putString("avalNombre", "Nuevo Aval"); // Puedes pasar un nombre predeterminado
                */
                Bundle args = new Bundle();
                String personJsonString = Utils.getGsonParser().toJson(aval);
                String personJsonString3 = aval_id;
                String personJsonString4 = "2";
                args.putString("aval", personJsonString);
                args.putString("avalId", personJsonString3);
                args.putString("tipo", personJsonString4);

                // Agregar Log para ver los datos que se envían
                Log.d("DATA_ENVIADA", "Json de avale: " + personJsonString);
                Log.d("DATA_ENVIADA", "ID de avaleId: " + personJsonString3);
                Log.d("DATA_ENVIADA", "ID de tipo: " + personJsonString4);

                dialogFragment.setArguments(args);
                dialogFragment.show(getChildFragmentManager(), "AvalesFotosDialog");
            }
        });

        btnEditarAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if(Validator.fieldValidation(tlAval, "Ingresa un nombre de aval")
                        && Validator.fieldValidation(tlTelefonoAval, "Ingresa un teléfono")
                        && Validator.fieldValidation(tlDireccionAval, "Ingresa una dirección")
                        && Validator.fieldValidation(tlOtrasReferenciasAval, "Ingresa otras referencias")
                        && Validator.fieldValidation(tlGarantiasAval, "Ingresa las garantías")
                        && Validator.fieldValidation(tlRuta, "Ingresa una ruta")
                        && Validator.fieldValidation(tlPoblacion, "Ingresa una población")
                        && Validator.fieldValidation(tlColocadora, "Ingresa una colocadora")
                ){
                    try {
                        editarAval();
                    } catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });

        btnUbicacion.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getCurrentLocation();
                Toast.makeText(getContext(), "Obteniendo ubicación", Toast.LENGTH_SHORT).show();
            }
        });

        /**
         *  RUTAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();

                if(poblacionesAutoCompleteTextView.getText().toString().length() > 0){
                    poblacionesAutoCompleteTextView.setText("");
                }
                if(colocadorasAutoCompleteTextView.getText().toString().length() > 0){
                    colocadorasAutoCompleteTextView.setText("");
                }

                List<Poblacion> poblacionesFiltro =
                        poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

            }
        });

        /**
         *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */

        poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = poblacionesAdapter.getItem(i);
                poblacion_id = poblacion.getId();

                if(colocadorasAutoCompleteTextView.getText().toString().length() > 0){
                    colocadorasAutoCompleteTextView.setText("");
                }

                List<Colocadora> colocadorasFiltro =
                        colocadoras.stream().filter(colocadora -> colocadora.getPoblacion_id().equals(poblacion_id))
                                .collect(Collectors.toList());

                colocadorasAdapter = new ArrayAdapter<Colocadora>(getContext(), android.R.layout.simple_dropdown_item_1line, colocadorasFiltro);
                colocadorasAutoCompleteTextView.setThreshold(1);
                colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);
            }
        });

        /**
         *  COLOCADORAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */

        colocadorasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {

                Colocadora colocadora = colocadorasAdapter.getItem(i);
                colocadora_id = colocadora.getId();

            }
        });
    }
    private void setRutaAutoComplete(String rutaId) {
        for (Ruta ruta : rutas) {
            if (ruta.getId().equals(rutaId)) {
                rutasAutoCompleteTextView.setText(ruta.getNombre_ruta() , false);  // Seteamos el nombre
                ruta_id = ruta.getId();
                break;
            }
        }
    }

    FusedLocationProviderClient client;

    @SuppressLint("MissingPermission")
    public void getCurrentLocation() {
        client = LocationServices
                .getFusedLocationProviderClient(
                        getActivity());
        LocationManager locationManager = (LocationManager)getActivity().getSystemService(Context.LOCATION_SERVICE);

        if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) || locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
            client.getLastLocation().addOnCompleteListener(
                    new OnCompleteListener<Location>() {
                        @Override
                        public void onComplete(@NonNull Task<Location> task) {
                            Location location = task.getResult();

                            if (location != null) {
                                lat = String.valueOf(location.getLatitude());
                                lgt = String.valueOf(location.getLongitude());

                                Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();
                            } else {
                                // When location result is null
                                // initialize location request
                                LocationRequest locationRequest = new LocationRequest()
                                        .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY)
                                        .setInterval(10000)
                                        .setFastestInterval(1000)
                                        .setNumUpdates(1);

                                LocationCallback locationCallback = new LocationCallback() {
                                    @Override
                                    public void
                                    onLocationResult(
                                            LocationResult
                                                    locationResult)
                                    {
                                        Location location1 = locationResult.getLastLocation();

                                        lat = String.valueOf(location1.getLatitude());
                                        lgt = String.valueOf(location1.getLongitude());

                                        Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();
                                    }
                                };

                                client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                            }
                        }
                    });
        } else {
            startActivity(new Intent(
                    Settings.ACTION_LOCATION_SOURCE_SETTINGS)
                    .setFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
        }
    }

    private void setPoblacionAutoComplete(String poblacionId) {
        for (Poblacion poblacion : poblaciones) {
            if (poblacion.getId().equals(poblacionId)) {
                poblacionesAutoCompleteTextView.setText(poblacion.getNombre_poblacion(), false);  // Seteamos el nombre
                poblacion_id = poblacion.getId();
                break;
            }
        }
    }

    private void setColocadoraAutoComplete(String colocadoraId) {
        for (Colocadora colocadora : colocadoras) {
            if (colocadora.getId().equals(colocadoraId)) {
                colocadorasAutoCompleteTextView.setText(colocadora.getNombre_completo(), false);  // Seteamos el nombre
                colocadora_id = colocadora.getId();
                break;
            }
        }
    }
    private void initElements(View view){

        CurrentFragment.fragment = "AvalesEditarFragment";

        btnSubirFotos = view.findViewById(R.id.btnSubirFotos);
        btnEditarAval = view.findViewById(R.id.btnEditarAval);
        btnUbicacion = view.findViewById(R.id.btnUbicacion);
// Asegúrate de que el botón no sea nulo
        if (btnEditarAval == null) {
            Log.e("AvalesEditarFragment", "btnEditarAval es null. Asegúrate de que el ID sea correcto en el layout.");
        } else {
            Log.d("AvalesEditarFragment", "btnEditarAval inicializado correctamente.");
        }
        tlAval = view.findViewById(R.id.tlNombreAval);
        tlDireccionAval = view.findViewById(R.id.tlDireccionAval);
        tlTelefonoAval = view.findViewById(R.id.tlTelefonoAval);
        tlOtrasReferenciasAval = view.findViewById(R.id.tlOtrasReferenciasAval);
        tlGarantiasAval = view.findViewById(R.id.tlGarantiasAval);
        tlRuta = view.findViewById(R.id.tlRuta);
        tlPoblacion = view.findViewById(R.id.tlPoblacion);
        tlColocadora = view.findViewById(R.id.tlColocadora);

        rutasAutoCompleteTextView = view.findViewById(R.id.acRuta);
        poblacionesAutoCompleteTextView= view.findViewById(R.id.acPoblacion);
        colocadorasAutoCompleteTextView= view.findViewById(R.id.acColocadora);

        pathsComprobantesAval = new ArrayList<>();
        pathsGarantiasAval = new ArrayList<>();

        archivosGeneral = new ArrayList<>();

        rutaController = new RutaController(getActivity());
        poblacionController = new PoblacionController(getActivity());
        colocadoraController = new ColocadoraController(getActivity());
    }

    private void getRutas() {
        // Verifica si ya tenemos rutas almacenadas en el controlador
        rutas = rutaController.obtener();

        if (rutas.size() == 0) {
            // Si no hay rutas, hacemos la solicitud a la API
            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");  // Parámetro para la API
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                JSONArray data = response.getJSONArray("data");  // Asegúrate de que 'data' es un JSONArray

                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);

                                    // Convierte el JSON en objeto Ruta
                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    // Agrega la ruta a la lista y la guarda en el controlador
                                    rutas.add(ruta);
                                    rutaController.nueva(ruta);
                                }

                                // Configura el Adapter y asigna al AutoCompleteTextView
                                rutasAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);  // Muestra sugerencias después de escribir 1 carácter
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, getActivity());  // Manejo de errores
                }
            });

            // Configura la política de reintento de la solicitud
            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,  // Tiempo máximo de espera
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,  // Número de intentos
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT  // Multiplicador de retroceso
            ));

            requestQueue.add(request);
        } else {
            // Si ya tenemos rutas, solo configuramos el Adapter con las rutas almacenadas
            rutasAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);  // Muestra sugerencias después de escribir 1 carácter
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);
        }
    }


    private void getPoblaciones()
    {

        if(poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
                /*  data.put("ruta_id", ruta_id);*/

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                //String data = response.get("data").toString();

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);

                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);


                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        }
        else{
            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
            poblacionesAutoCompleteTextView.setThreshold(1);
            poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);
        }
    }


    private void getColocadoras()
    {
        if(colocadoraController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            /*data.put("ruta_id", ruta_id);
            data.put("poblacion_id", poblacion_id);*/
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlColocadoras, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);


                                    Gson gson = new Gson();
                                    Colocadora colocadora = gson.fromJson(obj.toString(), Colocadora.class);

                                    colocadoras.add(colocadora);

                                }

                                colocadorasAdapter = new ArrayAdapter<Colocadora>(getContext(), android.R.layout.simple_dropdown_item_1line, colocadoras);
                                colocadorasAutoCompleteTextView.setThreshold(1);
                                colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }
        else{
            colocadoras = colocadoraController.obtener();

            colocadorasAdapter = new ArrayAdapter<Colocadora>(getContext(), android.R.layout.simple_dropdown_item_1line, colocadoras);
            colocadorasAutoCompleteTextView.setThreshold(1);
            colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);
        }
    }

    private void editarAval() throws JSONException {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "editAPP");
        RequestBody avalId = RequestBody.create(MediaType.parse("multipart/form-data"), aval_id);

        // Campos de la UI
        String nombreAval = tlAval.getEditText().getText().toString().trim();
        String direccionAval = tlDireccionAval.getEditText().getText().toString();
        String telefonoAval = tlTelefonoAval.getEditText().getText().toString();
        String orAval = tlOtrasReferenciasAval.getEditText().getText().toString();
        String garantiasAval = tlGarantiasAval.getEditText().getText().toString();

        // ⚡ FIX: Si los IDs vienen vacíos, usamos lo que ya está pintado en los AutoComplete
        if (ruta_id == null || ruta_id.isEmpty()) {
            ruta_id = rutasAutoCompleteTextView.getText().toString().trim();
        }
        if (poblacion_id == null || poblacion_id.isEmpty()) {
            poblacion_id = poblacionesAutoCompleteTextView.getText().toString().trim();
        }
        if (colocadora_id == null || colocadora_id.isEmpty()) {
            colocadora_id = colocadorasAutoCompleteTextView.getText().toString().trim();
        }

        RequestBody cantidad_archivos_garantias_aval =
                RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasAval.size() + "");
        RequestBody cantidad_archivos_aval =
                RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesAval.size() + "");

        Call<ResponseMe> call = retrofitInterface.editarAval(
                archivosGeneral,
                func,
                avalId,
                RequestBody.create(MediaType.parse("multipart/form-data"), nombreAval),
                RequestBody.create(MediaType.parse("multipart/form-data"), direccionAval),
                RequestBody.create(MediaType.parse("multipart/form-data"), telefonoAval),
                RequestBody.create(MediaType.parse("multipart/form-data"), ruta_id),
                RequestBody.create(MediaType.parse("multipart/form-data"), poblacion_id),
                RequestBody.create(MediaType.parse("multipart/form-data"), colocadora_id),
                RequestBody.create(MediaType.parse("multipart/form-data"), orAval),
                RequestBody.create(MediaType.parse("multipart/form-data"), garantiasAval),
                RequestBody.create(MediaType.parse("multipart/form-data"), lat),
                RequestBody.create(MediaType.parse("multipart/form-data"), lgt),
                cantidad_archivos_garantias_aval,
                cantidad_archivos_aval
        );

        // Petición secundaria (coords)
        JSONObject data = new JSONObject();
        data.put("func", "editCoords");
        data.put("id", aval_id);
        data.put("latitud", lat);
        data.put("longitud", lgt);

        vs = VolleyS.getInstance(this.getContext());
        requestQueue = vs.getRequestQueue();

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlAvales, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) { }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) { }
                });

        requestQueue.add(request);

        call.enqueue(new Callback<ResponseMe>() {
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {
                dialog.cancel();
                if (response.isSuccessful()) {
                    Log.d("response", response.body().getMessage());
                    Toast.makeText(getActivity(), "El aval se ha editado", Toast.LENGTH_LONG).show();

                    actualizarAvalEnSQLite(
                            aval_id,
                            nombreAval,
                            direccionAval,
                            telefonoAval,
                            orAval,
                            garantiasAval,
                            ruta_id,
                            poblacion_id,
                            colocadora_id
                    );

                    NavOptions navOptions = new NavOptions.Builder()
                            .setPopUpTo(R.id.nav_avales, true)
                            .build();

                    Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                            .navigate(R.id.nav_avales, null, navOptions);
                } else {
                    Toast.makeText(getActivity(), "Error de red, se guardó la edición en local", Toast.LENGTH_LONG).show();
                }
            }

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
                Toast.makeText(getActivity(), "Error de red, se guardó la edición en local", Toast.LENGTH_LONG).show();
                actualizarAvalEnSQLite(
                        aval_id, nombreAval, direccionAval, telefonoAval,
                        orAval, garantiasAval, ruta_id, poblacion_id, colocadora_id
                );
            }
        });
    }



    private void actualizarAvalEnSQLite(String avalId, String nombre, String direccion, String telefono,
                                        String otrasReferencias, String garantias,
                                        String rutaId, String poblacionId, String colocadoraId) {

        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // --- Validar valores y evitar null ---
        if (rutaId == null) rutaId = "";
        if (poblacionId == null) poblacionId = "";
        if (colocadoraId == null) colocadoraId = "";

        ContentValues valores = new ContentValues();
        valores.put("nombre_completo", nombre != null ? nombre : "");
        valores.put("direccion", direccion != null ? direccion : "");
        valores.put("telefono", telefono != null ? telefono : "");
        valores.put("otras_referencias", otrasReferencias != null ? otrasReferencias : "");
        valores.put("garantias", garantias != null ? garantias : "");
        valores.put("ruta_id", rutaId);
        valores.put("poblacion_id", poblacionId);
        valores.put("colocadora_id", colocadoraId);

        // Timestamp actual
        long timestamp = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate = sdf.format(new Date(timestamp));
        valores.put("updated_at", formattedDate);

        // Actualizar la fila correspondiente
        int filasActualizadas = db.update("avales", valores, "id = ?", new String[]{avalId});

        if (filasActualizadas > 0) {
            Log.d("SQLite", "Aval actualizado en SQLite con id: " + avalId);
            Toast.makeText(requireActivity(), "El aval " + nombre + " se ha editado correctamente", Toast.LENGTH_LONG).show();
        } else {
            Log.d("SQLite", "No se pudo actualizar el aval en SQLite con id: " + avalId);
        }

        db.close();
    }




    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float bitmapRatio = (float) width / (float) height;

        if (bitmapRatio > 1) {
            width = maxSize;
            height = (int) (width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int) (height * bitmapRatio);
        }

        Bitmap resizedBitmap = Bitmap.createScaledBitmap(bitmap, width, height, true);
        addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }
    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, fos);
        fos.flush();
        fos.close();
        return file;
    }
    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }
    private void addDateTimeToBitmap(Bitmap bitmap) {
        String currentDateTime = getCurrentDateTime();

        Canvas canvas = new Canvas(bitmap);

        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor("#80000000"));
        canvas.drawRect(0, bitmap.getHeight() - 40, bitmap.getWidth(), bitmap.getHeight(), backgroundPaint);

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE); // Color del texto
        textPaint.setTextSize(18); // Tamaño del texto
        textPaint.setAntiAlias(true); // Suavizar el texto

        float x = 10;
        float y = bitmap.getHeight() - 15;

        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(AvalesEditarViewModel.class);
        // TODO: Use the ViewModel
    }

}